module load samtools/latest
#Which library
fastqDir="~/MIP_data_and_analysis/Accessions"
refDir="~/MIP_data_and_analysis/100_repeat_reference_seqs/"

#for each library (say 96 accession folders)
for lib in `ls $fastqDir`
do
	libDir=$fastqDir/$lib
	echo $libDir
	#make an alignments directory
	mkdir $libDir/alignments
	for fastforward in `ls $libDir | grep _1.fastq`
	do
		#make sam, bam, sorted and sorted bam files
		fastforwardpath=$libDir/$fastforward
		echo "   $fastforward"
		fastprefix=`echo $fastforward | cut -f 1,2 -d _ -`
		ref=`ls $refDir/*.fasta | grep ${fastprefix}_ `
		echo "           $ref"
		echo "MAPPING..."
		bwa bwasw $ref $libDir/$fastforward >$libDir/alignments/${fastprefix}.sam
		echo "BAMING..."	
		samtools view -bS $libDir/alignments/${fastprefix}.sam > $libDir/alignments/${fastprefix}.bam
		echo "SORTING..."	
		samtools sort $libDir/alignments/${fastprefix}.bam $libDir/alignments/${fastprefix}.sorted
		echo "INDEXING..."			
		samtools index $libDir/alignments/${fastprefix}.sorted.bam
	done
done
